/*== DIGISTANT 4422  bp4422 Include File ======================*/
#include <vpptype.h>
/*== defines for serial communication =========================*/
#define NUL      0x00
#define STX      0x02
#define ETX      0x03
#define EOT      0x04
#define ENQ      0x05
#define ACK      0x06
#define CR       0x0D
#define NAK      0x15

/*== defines for program=======================================*/
#define bp4422_MAX_INSTR   10
#define bp4422_MAX_CMD     100

#define bp4422_CAL_RTD_ILOW   0
#define bp4422_CAL_RTD_IHIGH  1
#define bp4422_CAL_RTD_200OHM 0
#define bp4422_CAL_RTD_2KOHM  1

#define bp4422_MIN_V_IN      -12.0
#define bp4422_MAX_V_IN      12.0

#define bp4422_MIN_MV_IN     -12000.0
#define bp4422_MAX_MV_IN     12000.0

#define bp4422_MIN_MA_IN     -30.0
#define bp4422_MAX_MA_IN     30.0

#define bp4422_MIN_V      -11.0
#define bp4422_MAX_V      11.0

#define bp4422_MIN_MV     -11000.0
#define bp4422_MAX_MV     11000.0

#define bp4422_MIN_MA     -22.0
#define bp4422_MAX_MA     22.0

#define bp4422_MIN_OHM    10.0
#define bp4422_MAX_OHM    1999.99  /* abgerundet wegen Compiler Fehler 4422*/

#define bp4422_MIN_K      0.0
#define bp4422_MAX_K      2999.99	/* abgerundet wegen Compiler Fehler 4422*/

#define bp4422_MIN_GRD_C  -273.15
#define bp4422_MAX_GRD_C  2726.84	/* abgerundet wegen Compiler Fehler 4422*/

#define bp4422_MIN_GRD_F  -459.67
#define bp4422_MAX_GRD_F  4940.31	/* abgerundet wegen Compiler Fehler 4422*/

#define bp4422_VOLTAGE_ERROR     (1<<0)/* Bit 0 of Questionable Condition Register*/
#define bp4422_CURRENT_ERROR     (1<<1)/* Bit 1 of Questionable Condition Register*/
#define bp4422_TEMP_ERROR        (1<<4)/* Bit 4 of Questionable Condition Register*/
#define bp4422_CAL_ERROR         (1<<8)/* Bit 8 of Questionable Condition Register*/
#define bp4422_LOW_BAT_ERROR     (1<<9)/* Bit 9 of Questionable Condition Register*/
#define bp4422_OUT_OVER_ERROR    (1<<10)/* Bit 10 of Questionable Condition Register*/
#define bp4422_IN_OVER_ERROR     (1<<11)/* Bit 11 of Questionable Condition Register*/
#define bp4422_P_OVER_ERROR      (1<<12)/* Bit 12 of Questionable Condition Register*/

#define bp4422_DEVICE_DEPT_ERROR (1<<3)/* Bit 3 of Standard Event Register*/
#define bp4422_EXECUTION_ERROR   (1<<4)/* Bit 4 of Standard Event Register*/

#define bp4422_DEVICE_CALIBRATION (1<<0)/* Bit 0 of Operation Status Register*/
#define bp4422_DEVICE_MEASURING  (1<<4)/* Bit 4 of Operation Status Register*/
#define bp4422_DEVICE_EOC        (1<<8)/* Bit 8 of Operation Status Register*/
#define bp4422_DEVICE_P_EOC      (1<<9)/* Bit 9 of Operation Status Register*/
#define bp4422_DEVICE_P_BATT_EOC (1<<10)/* Bit 10 of Operation Status Register*/
#define bp4422_DEVICE_P_TARE_EOC (1<<11)/* Bit 11 of Operation Status Register*/ 

/*== GLOBAL FUNCTION DECLARATIONS =========================================*/

int _VI_FUNC bp4422_init(int ,int,double,int,int,int,char*,int,int *);

int _VI_FUNC bp4422_calc_state(int instrID,int state);
int _VI_FUNC bp4422_calc_reset(int instrID);

int _VI_FUNC bp4422_config(int ,int,int ,int ,int ,int );
int _VI_FUNC bp4422_config_p_module(int instrID,int module_no,char* s_no,
                           char* cal_date,char* unit,
                           double zero_voltage, double zero_p_value,
                           double final_voltage, double final_p_value,
                           double max_value);
int _VI_FUNC bp4422_get_config_p_module(int instrID,int module_no,char* name,char* s_no,
                           char* cal_date,char* unit,
                           double* zero_voltage, double* zero_p_value,
                           double* final_voltage, double* final_p_value,
                           double* max_value);

int _VI_FUNC bp4422_config_grounding(int ,int);
int _VI_FUNC bp4422_config_output_tc_rj(int ,int ,double ,double);
int _VI_FUNC bp4422_config_input_tc_rj(int ,int ,double ,double);

int _VI_FUNC bp4422_set_value(int ,int ,int,double);

int _VI_FUNC bp4422_start_measure(int ,int);
int _VI_FUNC bp4422_read_measure_string(int ,char* );
int _VI_FUNC bp4422_read_p_measure(int ,double*,char* );
int _VI_FUNC bp4422_read_p_measure_string(int ,char* );
int _VI_FUNC bp4422_read_measure(int ,double*,char* );
int _VI_FUNC bp4422_stop_measure(int );
int _VI_FUNC bp4422_select_p_module_no(int instrID,int module_no);
int _VI_FUNC bp4422_select_p_module_name(int instrID,char * name);

int _VI_FUNC bp4422_tare_p_state(int instrID,int state );
int _VI_FUNC bp4422_tare_p_init(int instrID);
int _VI_FUNC bp4422_get_tare_p_value(int instrID ,char* value);
int _VI_FUNC bp4422_get_p_module_name(int instrID,int module_no,char* name);
int _VI_FUNC bp4422_store_p_module_name(int instrID,int module_no,char* name);
int _VI_FUNC bp4422_check_p_module_batterie(int instrID ,char* value);

int _VI_FUNC bp4422_clear_all_datalogger(int instrID);
int _VI_FUNC bp4422_clear_datalogger_block(int instrID,int block_nr);
int _VI_FUNC bp4422_set_datalogger_mode(int instrID,int dmode);
int _VI_FUNC bp4422_set_datalogger_time(int instrID,double dtime);
int _VI_FUNC bp4422_datalogger_start_stop(int instrID,int start);
int _VI_FUNC bp4422_datalogger_step(int instrID);
int _VI_FUNC bp4422_datalogger_aver_devi(int instrID,int block_nr,double *average,
                                double *deviation,char* unit);
int _VI_FUNC bp4422_datalogger_min_max(int instrID,int block_nr,double *min_value,
                            double *max_value,char* unit);
int _VI_FUNC bp4422_read_datalogger(int ,int ,int* ,char*,char* ,char* );
int _VI_FUNC bp4422_read_datalogger_value(int ,int ,int* ,char*,char* ,double*,char* );

int _VI_FUNC bp4422_set_ramp_mode(int instrID,int rmode);
int _VI_FUNC bp4422_ramp_start_stop(int instrID,int start);
int _VI_FUNC bp4422_ramp_step(int instrID,int smode);
int _VI_FUNC bp4422_init_ramp1(int instrID,int waveform,int number,double step_time,
                      int type,double start_value,double stop_value,
                      double step_value);
int _VI_FUNC bp4422_init_ramp2(int instrID,int waveform,int number,int points);
int _VI_FUNC bp4422_init_ramp2_list(int instrID,int type,int list_nr,double value,
                            double step_time);

int _VI_FUNC bp4422_set_display_backlight(int instrID,int state,double btime);
int _VI_FUNC bp4422_set_display_contrast(int instrID,double value);

int _VI_FUNC bp4422_system_error(int,char*);
int _VI_FUNC bp4422_system_keyboard(int,int);
int _VI_FUNC bp4422_get_status(int );
/*int _VI_FUNC bp4422_cal_state(int,int);
int _VI_FUNC bp4422_cal_curr_adjust(int,int,int);
int _VI_FUNC bp4422_cal_volt_adjust(int,int,int);
int _VI_FUNC bp4422_cal_curr_data(int,double,double);
int _VI_FUNC bp4422_cal_volt_data(int,double,double);
int _VI_FUNC bp4422_cal_rref(int ,int,double);
int _VI_FUNC bp4422_cal_pt100(int );
int _VI_FUNC bp4422_cal_rtd_adjust(int ,int ,int ,int);
int _VI_FUNC bp4422_cal_rtd_data(int ,double ,double);

int _VI_FUNC bp4422_get_cal_status(int ,int*)  ;
int _VI_FUNC bp4422_get_cal_err(int ,int*,int* );	 

int _VI_FUNC bp4422_get_eoc(int instrID);
int _VI_FUNC bp4422_get_p_eoc(int instrID);			 */

int _VI_FUNC bp4422_send_scpi(int,char*);
int _VI_FUNC bp4422_receive_scpi(int ,char*,char*);


int _VI_FUNC bp4422_close (int);


/*=============================== END =====================================*/





// Muss fr die Treiberfreigabe wieder im C-File deklariert sein!!!

int _VI_FUNC bp4422_config_input_type(int instID,int type,int rtd_type,int tc_type);
void change_character_pc_disp4422(char* source,char *dest);
void change_character_disp4422_pc(char* source,char *dest);
